/*jslint this */

/*property
    data, drawImage, fontScaleX, fontScaleY, getContext, getFullContext, height,
    opacity, prototype, remove, saveImageToFile, scaleFont, setStyle, show, src,
    style, textCount, theStyle, widgetDataFolder, width, window
*/

"use strict";

///////////////////////////////// Start of the Canvas Text functions ///////////////////////////////
Canvas.prototype.getFullContext = function (s) {
    var ctx = this.getContext(s);

    ctx.window = this.window;
    ctx.fontScaleX = 1;
    ctx.fontScaleY = 1;
    ctx.theStyle = "font-family:'Courier New'; font-size:12px; font-weight:normal; font-style:normal; opacity:1.0";   // default style
    ctx.textCount = 0;

    ctx.scaleFont = function (scaleX, scaleY) {
        ctx.fontScaleX *= scaleX;
        ctx.fontScaleY *= scaleY;
    };
    ctx.setStyle = function (style) {
        ctx.theStyle = style;
    };

    ctx.show = function (x, y, string) {
        var txt = new Text();
        txt.window = ctx.window;
        txt.style.setStyle(ctx.theStyle);
        txt.data = string;
        var width = txt.width;
        var height = txt.height;
        var path = system.widgetDataFolder + "/show" + ctx.textCount;
        txt.saveImageToFile(path, "png");
        txt.opacity = 0;
        txt = null;

        var img = new Image();
        img.window = ctx.window;
        img.opacity = 255;
        img.src = path;
        ctx.drawImage(img, x, y, width / ctx.fontScaleX, height / ctx.fontScaleY);
        img.opacity = 0;
        filesystem.remove(path);
        img = null;
        ctx.textCount += 1;
        ctx.textCount %= 1024;
    };

    return ctx;
};
///////////////////////////////// End  of  the Canvas Text functions ///////////////////////////////
